﻿#pragma once
#define ASSERTS_ENABLED

namespace RTCam {
	namespace Assert {
		void AssertFail(_In_z_ const char* condition, _In_z_ const char* msg, _In_z_ const char* file, int line);
	}
} 

#ifdef ASSERTS_ENABLED
	#define ASSERT(x) \
		do { if (!(x)) { RTCam::Assert::AssertFail(#x, nullptr, __FILE__, __LINE__); } } while(0)
	#define ASSERT_MSG(x, y) \
		do { if (!(x)) { RTCam::Assert::AssertFail(#x, y, __FILE__, __LINE__); } } while(0)
#else
	#define ASSERT(x) \
		do { (void)sizeof(x); } while(0)
#endif